<?php
session_start();
require 'vendor/autoload.php';
$config = require 'config.php'; 

use Auth0\SDK\Auth0;
use Auth0\SDK\Configuration\SdkConfiguration;
use GuzzleHttp\Client;
use Http\Adapter\Guzzle7\Client as GuzzleAdapter;

$httpClient = new GuzzleAdapter(new Client());
$auth0 = new Auth0(new SdkConfiguration([
    'domain'        => $config['domain'],
    'clientId'      => $config['client_id'],
    'clientSecret'  => $config['client_secret'],
    'redirectUri'   => $config['redirect_uri'],
    'cookieSecret'   => $config['cookie_secret'],
    'scope' => ['openid', 'profile', 'email'], 
	'httpClient' => $httpClient, 
]));


//echo bin2hex(random_bytes(32)); exit;


$loginUrl = $auth0->login();

$pdo = new PDO('mysql:host=localhost;dbname=pupa_testeesensors', 'pupa_testeesensors', 'AKIAQUDCHTIL5WPKQOKA');
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user'] = $user;
        header('Location: dashboard.php');
        exit();
    } else {
        echo "<script>alert('Invalid username or password');</script>";
    }
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body { font-family: Arial, sans-serif; text-align: center; margin-top: 50px; }
        .container { width: 300px; margin: auto; }
        input { width: 100%; padding: 10px; margin: 10px 0; }
        button { width: 100%; padding: 10px; background: #007bff; color: white; border: none; }
        .social-login { margin-top: 20px; }
        .social-login a { display: block; padding: 10px; margin: 5px 0; text-decoration: none; background: #eee; border-radius: 5px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Welcome</h2>
        <form method="POST">
            <input type="text" name="username" placeholder="Email address" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Continue</button>
        </form>
        <div class="social-login">
            <p>OR</p>
            <a href="<?php echo $loginUrl; ?>"><i class="fab fa-google"></i> Continue with Google</a>
            <a href="<?php echo $loginUrl; ?>"><i class="fab fa-linkedin"></i> Continue with LinkedIn</a>
            <a href="<?php echo $loginUrl; ?>"><i class="fab fa-microsoft"></i> Continue with Microsoft</a>
            <a href="<?php echo $loginUrl; ?>"><i class="fab fa-github"></i> Continue with GitHub</a>
            <a href="<?php echo $loginUrl; ?>"><i class="fab fa-okta"></i> Continue with Okta</a>
            <a href="<?php echo $loginUrl; ?>"><i class="fab fa-windows"></i> Continue with Microsoft Entra ID</a>
        </div>
    </div>
</body>
</html>


